//===============================================================================================
// Sets up and provides methods to support the help frame page
// that manages the help dialog.
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

gbDebug = false;
gDebugMsgs = null;

gbPopupMode = false;

gbFeedback = false;

gNavBar = null;			// navbar iframe window
gViewer = null;			// viewer object
gSideNavigator = null;	// side navigator
gHelpCenter = null;		// Help center page
gFAQArray = null;
gAppMode = "";

gFirstQuery = null;
gFirstContext = null;
gCachedFormContext = null;
	// Save off the last known form/field context to handle cases where
	// there is not active form since the help window is the active window.

//-----------------------------------------------------------------------------------------------
function main( bPopupMode, bSingleFrame )
	// Initialize the page when loaded
{
	// Adjust for IE5
	if(isIE5()) document.body.className = "ie5";

	gbPopupMode = ( bPopupMode ) ? true : false;
		// true if the help window is a small popup
		
	gbFeedback = ( bSingleFrame ) ? true : false;
		
	gNavBar = frames[0];
	
	if ( gbPopupMode )
		gViewer = new zViewer( frames[1], frames[0] );	
	else if ( gbFeedback )
		gViewer = new zViewer( frames[0] );
	else
		gViewer = new zViewer( frames[2], frames[0], frames[1] );	
		
	if (!gbFeedback && !gbPopupMode)
	{
		gSideNavigator = frames[1];
		gSideNavigator.renderYourself();
	}
	
	// Ask the C++ handler to pass the arguments via setArgs
	onCmd( "initArgs" );

	if( !gbPopupMode && !gbFeedback ) 
		window.onresize = onResize;
	onResize();

	var args = getLastCmdResultList();
	if( !args ) 
	{
		return;
	}

	// args in following order
	//		helpCenterPage, query, context, results per page, word count, debug info flag
	var cnt;

	for( var key in args )
	{
		switch( key )
		{
			// Help Center
			// Replace Help Center with array of hash questions.
			// This will be an array of zContext;
			case "0": 
				gFAQArray = args[key];
				break;

			// Query
			case "1": 
				if( args[key] ) gFirstQuery = unescape(args[key]); 
				break;
			// change the query displayed in the edit box
			// Context
			case "2":
				gFirstContext = args[key];
				break;

			// Results per page
			case "3":
				// Set the global search request behavior for results per page
				cnt = args[key];
				if( cnt>0 ) zSearchRequest.prototype.resultsPerPage = args[key];
				break;

			// Summary word count
			case "4":
				// Set the global search request behavior for summary word count
				cnt = args[key];
				if( cnt>0 ) zSearchRequest.prototype.summaryWordCnt = args[key];
				break;
				
			// debug info
			case "5": 
				gbDebug = ( args[key] ) ? true : false;
				if( (gbDebug) && (!gbFeedback) ) gNavBar.enableDebugMenu();
				break;
				
			// Check the mode: 1.PreInterview 2.EasyStep 3.Forms
			case "6": 
				gAppMode = args[key];
				break;
		}
	}
	
	// Set global behaviors for request objects
 	zRequestBase.prototype.bDebug = gbDebug; 	
 	zRequestBase.prototype.appMode = gAppMode;
	zSearchRequest.prototype.onNoResults = handleNoSearchResults;
	zHelpItemRequest.prototype.onFail = handleItemFail;
	zHelpFAQRequest.prototype.onFail = handleFAQFail;
	zFieldHelpItemRequest.prototype.onFail = handleFieldItemFail;
	
	// if there is an FAQ array, display the FAQs
	if( gFAQArray ) setTimeout("displayFAQs()",100);
	else if ( (gFirstContext) && ( !gbPopupMode ) ) 
	{
		// if there is NO FAQ array, but it is full screen help and there is context
		if (gFirstContext.formId)	// if there is a form id, we can display with displayFAQs
		{
			setTimeout("displayFAQs()",100);
		}
		else	// if there is no form id, there may be programHelp and a screen id, so display it with displayContext
		{
			setTimeout( "displayContext()", 100 );
		}
	}
	else if( gFirstContext ) setTimeout( "displayContext()", 100 );		// a popup
	else if ( gbFeedback ) setTimeout( "goPopupFeedback()", 100 );		// feedback
	else if( !gbPopupMode ) setTimeout( "search()", 100 );				// no longer being used but could come back.
	// else if( gbPopupMode ) error condition...do nothing, show blank
}

//-----------------------------------------------------------------------------------------------
function setQueryBox( query )
	// Set the value displayed in the search edit box
{
	if( gViewer && gViewer.wnd.searchBoxSetQuery ) gViewer.wnd.searchBoxSetQuery(query);
}
 
//-----------------------------------------------------------------------------------------------
function getPreviousRequest(){ return gViewer.previousRequest(); }
	// Return the previous item in the history list
	
//-----------------------------------------------------------------------------------------------
function search( query )
{
	if( !query && gFirstQuery )
	{
		query = gFirstQuery;
		gFirstQuery = null;
	}
	
	if( !query || query.length == 0 )
	{
		goHelpCenter();
		return;
	}
	
	gViewer.navigate( new zSearchRequest(query) );
}

//-----------------------------------------------------------------------------------------------
function displayFAQs( context, formfield, appMode )
// Display the help content associated with the specified context
{
	// When this function is called, 
	try
	{
		if (appMode)		// if we are using arguments...
		{
			gAppMode = appMode;
			if (!context)
				gFAQArray=null;
			else 
				gFAQArray = context;
		}

		var contextArray = null;
		if ( gFAQArray )
		{
			contextArray = new Array();
			for(index = 0; index< gFAQArray.length; index++)
			{
				contextArray.push( gFAQArray[index].filename );
			}
		}
		//gFAQArray = null;
	
		// See if there is a form id and field id to display government instructions and tax help.
		var formid="";
		var fieldid="";
		if (formfield)
			gFirstContext = formfield;
	
		if ( gFirstContext )
		{
			if ( gFirstContext.formId )
			{
				formid = gFirstContext.formId;
				if (gFirstContext.fieldId) 
					fieldid=gFirstContext.fieldId;
			}
			else
			{
				displayContext();
			}
		}
		
		var req = null;
		if (contextArray && gFAQArray)
		{
			req = new zHelpFAQRequest( contextArray, gFAQArray[0].ctype.type, "", formid, fieldid );	
		}
		else	// no FAQs
		{
			req	= new zHelpFAQRequest( null, "appfaq", "", formid, fieldid );	
		}

		req.appMode=gAppMode;
		gViewer.navigate( req );
	}
	catch(e)
	{
		handleFAQFail();
	}
}

//-----------------------------------------------------------------------------------------------
function displayContext( context, bFromHyper, bTaxInfo, bGovOnly )
	// Display the help content associated with the specified context
{
	try
	{
		if( !context )
		{
			context = gFirstContext;
			gFirstContext = null;

			if( !context ) throw "No help context";
		}
		
		var req = null;
		if( context.formId )
		{
			gCachedFormContext = context;
			req = new zFieldHelpItemRequest( context.formId, context.fieldId, bGovOnly );
		}
		else if( context.ctype )	
		{
			if( context.ctype.name == kStaticHtmlHelp.toLowerCase() ) 
			{
				req = new zStaticItemRequest( context.filename );
			}
			else if( context.ctype.name == kVideoLib.toLowerCase() )
			{
				goVideoLibrary();
				return;
			}
			else 
			{
				// can be used for hyperToPrgHelp where filename is the screenid...type is kProgramHelp
				req = new zHelpItemRequest( null, context.filename, context.ctype.type );
			}
		}	
		else throw "No context found";
				
		if( bTaxInfo ) req.onFail = handleFieldItemFail;
				
		if( gbPopupMode )
		{
			req.bPopupMode = true;
			if( !bFromHyper ) gViewer.clearHistory();
		}

		gViewer.navigate( req );
	}
	catch(e)
	{
		if( bTaxInfo ) handleFieldItemFail();
		else handleItemFail();
	}
}

//-----------------------------------------------------------------------------------------------
function handleNoSearchResults()
	// Callback invoked when no search results were found
{
	var req = gViewer.currentRequest();
	var query = ( req && req.constructor == zSearchRequest ) ? req.query : "";

	gViewer.loadPage( "dhtmlHelpNoResult.htm?query=" + escape(query) );
}

function handleNoContextSensitiveResults()
{
	if (gbPopupMode) return;
	
	gViewer.loadPage("NoContextHelp.htm");
}
 	
//-----------------------------------------------------------------------------------------------
function handleItemFail()
{
	if( gbPopupMode ) return;
	
	if (gSideNavigator)
		gSideNavigator.enableAllButtons();
	gViewer.loadPage( "NoContextSensitiveHelp.htm" );
}

function handleFAQFail()
{
	if( gbPopupMode ) return;
	if (gSideNavigator)
		gSideNavigator.enableAllButtons();
	gViewer.loadPage( "NoContextSensitiveHelp.htm" );
}

function goMoreInfo()
{
	// get the last faqs
	//var req = gViewer.getLastFAQs();
	//if (req)
	//	gViewer.navigate( req );
	//else
	//	gViewer.loadPage( "NoContextSensitiveHelp.htm" );
	onCmd("goFAQContext");
}

//-----------------------------------------------------------------------------------------------
function handleFieldItemFail(bAddHistory)
{
	if( gbPopupMode ) return;
	
	var href = "NoContextSensitiveHelp.htm";
	
	if( bAddHistory ) gViewer.navigate( new zStaticPageRequest(href) );
	else gViewer.loadPage(href);
}

//-----------------------------------------------------------------------------------------------
function goItem( indexFilename, filename, helpType, title, summary )
	// Display the specified help content
{
	var req = new zHelpItemRequest( indexFilename, filename, helpType, title, summary );
	if( gbPopupMode ) req.bPopupMode = true;

	gViewer.navigate( req );
}

//-----------------------------------------------------------------------------------------------
function goFindRelated()
	// Search for items related to the current item
{
	var req = gViewer.currentRequest();
	var query = "";
	if( req.title && req.title.length>0 ) query += req.title + ' ';
	if( req.relatedQuery ) query += req.relatedQuery;

	search( query );
}

//-----------------------------------------------------------------------------------------------
function goPrint()
{
	gViewer.wnd.focus();
	setTimeout( 'gViewer.wnd.print()', 100 ); // relinquish control to browser to set focus
}

//-----------------------------------------------------------------------------------------------
function goHelpCenter( opt )
{
	if( gbPopupMode ) return;
	
	hyperToPrgHelp(null,"scr30561");		// Go to Common questions until I fix it so that FAQ's 
											// come up.
	gViewer.navigate( new zStaticPageRequest( "NoContextSensitiveHelp.htm", opt ) );
}

function goPopupFeedback( opt )
{
	// Get C++ handler for a list of installed states,
	// the name are used as subcategories in the dialog
	onCmd( "getInstalledStates" );
	var args = getLastCmdResultList();
	
	var installedStates = null;
	if ( args )
		installedStates = args[0];
		
	var req = new zFeedbackRequest( installedStates, gFirstQuery );
	
	gViewer.navigate( req );

}

//------------------------------------------------------------------------------------------------
function goVideoLibrary()
{
	gViewer.navigate( new zStaticPageRequest( "dhtmlHelpVideoLibrary.htm" ) );
}

//------------------------------------------------------------------------------------------------
function goStaticPage( filename, opt )
{
	gViewer.navigate( new zStaticPageRequest( filename, opt ) );
}

//------------------------------------------------------------------------------------------------
function goBack(){ gViewer.goBack(); }
function goForward(){ gViewer.goForward(); }
function updateNav(){ gViewer.updateNav(); }

//-----------------------------------------------------------------------------------------------
function getFormFieldContext()
	// Get the current form field context form C++
{
	parent.onCmd( "getFormFieldContext" );
	var args = parent.getLastCmdResultList();
	if( !args || args.length < 1 ) return null;
	
	return args[0];	
}

//------------------------------------------------------------------------------------------------
// Interface for Content Page -  these methods are called from within the content item
//------------------------------------------------------------------------------------------------
function getProductVariant( bRefresh )
{
	if( bRefresh ) gViewer.setCurrentFormsetContext();
	
	var cntx = gViewer.getCurrentFormsetContext();
	return (cntx) ? cntx.productVariant : "";
}

//------------------------------------------------------------------------------------------------
function getChannel()
	// Return the channel associated with the product (Direct, Retail, Download)
{
	// Ask the C++ handler for the channel
	onCmd( "getChannel" );
	return getLastCmdResult();
}

//------------------------------------------------------------------------------------------------
function hyperToUrl(href)
	// Open an external url in a new browser window
{
	var url = ( href.match( /^[a-z]+:\/\//i ) ) ? "" : "http://";
	url += unescape(href);

	window.open( url, "_blank" );
}

	
//------------------------------------------------------------------------------------------------
function hyperToHelp(href){ displayContext( new zContext(kTaxHelp,null,href), true, true ); }
	// Jump to the specified item in the tax help bucket
	
//------------------------------------------------------------------------------------------------
function hyperToGov(href){ displayContext( new zContext(kGovHelp,null,href), true, true ); }
	// Jump to the specified item in the gov instructions bucket
	
//------------------------------------------------------------------------------------------------
function hyperToPrgHelp(href,screenid){ displayContext( new zContext(kProgramHelp,screenid,href), true ); }
	// Jump to the specified item in the program help bucket
	
//------------------------------------------------------------------------------------------------
function hyperTo(href,screenid){ displayContext( new zContext(kHyperHelp,screenid,href), true ); }
	// Jump to a item in the hyperhelp help bucket

//------------------------------------------------------------------------------------------------
function JumpTo(href)
	// Jump to a page in the current bucket
{
	var curReq = gViewer.currentRequest();	
	var ctype = findContextTypeByType( curReq.helpType );
	if( !ctype ) return;
	
	displayContext( new zContext(ctype.name,null,href) );
}

function getViewerHeight()
{
	var winH = getWindowHeight();
	var nav = document.getElementById("navbar");
	var vwr = document.getElementById("viewer");
	var y = nav.offsetTop+nav.offsetHeight;
	
	return (winH - y);
}
//-----------------------------------------------------------------------------------------------
// Event Handlers
//-----------------------------------------------------------------------------------------------
function onResize()
	// Handle the resizing of the window
{
	if ( gbPopupMode )
	{
		onPopupResize();
	}
	else if (gbFeedback )
	{
		onFeedbackResize();
	}
	else
	{
		var winH = getWindowHeight();
		var winW = getWindowWidth();
		
		// Resize the content viewing area to fill up the window
		var vwr = document.getElementById("viewer");
		var nav = document.getElementById("navbar");
		var side = document.getElementById("sideNavigator");
		if( vwr && nav && side )
		{
			var y = nav.offsetTop+nav.offsetHeight;
			var x = side.offsetLeft+side.offsetWidth;
			var h = winH - y;
			var sideHeight = h;
			if (h < 0) 
				h = 0; // when user resizes to smallest; fix bug #TWTE002145
			else
				if (h > 30)
					h = h - 30;
					
			if (sideHeight < 0)
				sideHeight=0;
			
			vwr.style.top = y + "px";
		    vwr.style.height = h + "px"; // the padding
			side.style.top = y + "px";
			side.style.height = sideHeight + "px";			
			// when user resizes to smallest; fix bug #TWTE002145
			if ( (winW < x) || ((winW - x) < 15) )
			{			
			   vwr.style.width = 15;
			}
			else
			{
			   vwr.style.width = winW - x - 15;  // the padding
			}			
			show(vwr);
			show(side);
			if (gSideNavigator)
				gSideNavigator.resizeYourself( sideHeight );
		}
	}
}

function onPopupResize()
	// Handle the resizing of the window
{
   	var winH = getWindowHeight();
   	
   	// Resize the content viewing area to fill up the window
   	var vwr = document.getElementById("viewer");
   	var nav = document.getElementById("navbar");
  	if( vwr && nav )
   	{
   		var y = nav.offsetTop+nav.offsetHeight;
   		var h = winH - y;
   		vwr.style.top = y + "px";
   		vwr.style.height = h + "px";
   		show(vwr);
	}
}

function onFeedbackResize()
{
	var winH = getWindowHeight();
	var vwr = document.getElementById("viewer");
	vwr.style.height = "100%";
	vwr.style.width = "100%";
	vwr.style.top = "0px";
	vwr.style.left = "0px";
	show(vwr);
}


//-----------------------------------------------------------------------------------------------
// Debug
//-----------------------------------------------------------------------------------------------
function debugMsg( msg, bAlert )
{
	if( gbDebug )
	{		
		if( bAlert ) alert( msg );
	
		if( !gDebugMsgs ) gDebugMsgs = new Array();
		gDebugMsgs.push( msg );
	}	
} 

//-----------------------------------------------------------------------------------------------
function showDebugMenu()
{
	var opt = "status=no,toolbar=yes,menubar=yes,location=no,resizable=yes,scrollbars=yes";
	window.open( "dhtmlHelpDebug.htm", "HelpDebug", opt );
}
